//*********************************************************************
//  GolfScores.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.36 (5E, p. 290)
//*********************************************************************

import java.io.*;
import java.util.*;

public class GolfScores
{
   //-----------------------------------------------------------------
   //  Reads golf score information and produces a summary.
   //-----------------------------------------------------------------
   public static void main (String [] args)
   {
      try
      {
         int[] scores = new int[5];

         BufferedReader in = new BufferedReader (
                           new FileReader (new File(args[0])));

         for (int hole = 0; hole < 18; hole++)
         {
            StringTokenizer read = new StringTokenizer (in.readLine());
            for (int player = 0; player < 5; ++player)
               scores [player] += Integer.parseInt (read.nextToken());
         }

         //  determine minimum score for hole
         int min = scores[0];
         for (int idx = 1; idx < scores.length; ++idx)
            if (scores[idx] < min)
               min = scores[idx];

         int base = min - 5;
         System.out.print ("Par:\t" + scores [0] + "\t\t| ");

         //  make bars
         for (int count = 0; count < scores[0]-base; ++count)
            System.out.print ("*");
         System.out.println ();

         for (int player = 1; player < 5; ++player)
         {
            System.out.print ("P" + player + ":\t" +
                              scores[player] + "\t" +
                              (scores[player] - scores [0]) + "\t| ");
            for (int count = 0; count < scores[player]-base; ++count)
               System.out.print ("*");
            System.out.println ();
         }
      }
      catch (Exception e)
      {
         e.printStackTrace (System.err);
         System.out.println ("Usage: java GolfScores filename");
      }
   }
}
